//Coulson & Richardson Chemical Engineering, Volume:01, 6th edition
//Chapter:11, The Boundary layer
//Exercise:11.3, Page No.: 684
//Title: Application of the boundary layer thickness
//=============================================
model Ex11_3

//=============================================
//Variable section
Real Q_1(unit = "m3/s") "volumetric flowrate in m3/s";
Real G(unit = "kg/s") "mass flowrate";
Real Re "Reynolds number";
Real del_b(unit = "m") "thickness of laminar sub-layer in m";
Real del_b1(unit = "mm") "thickness of laminar sub-layer in mm";
Real u(unit = "m/s") "mean velocity";
Real u_b(unit = "m/s") "velocity of laminar sub-layer";

//=============================================
//Parameter section
parameter Real rho(unit = "kg/m3") = 870 "density of benzene";
parameter Real mu(unit = "Ns/m2") = 0.7e-3 "viscosity of benzene";
parameter Real D(unit = "m") = 50e-3 "diameter of pipe";
parameter Real Q(unit = "l/s") = 2 "volumetric flowrate in l/s";

//=============================================
//Library section
extends Modelica.Constants;

//=============================================
//Equation section
equation
Q_1 = Q/1000;
//1000 is divided to convert units from l/s to m3/s
G = Q_1*rho;
Re = 4*G/(mu*D*pi);
del_b = (62*(Re^(-7/8)))*D;
del_b1 = del_b*1000;
//1000 is multiplied to convert m to mm
//From equation 11.49, Page No.: 684
u = G/(rho*(pi*(D^2))/4);
u_b = (2.49/(Re^(1/8)))*u;
//From equation 11.47, Page No.:683


end Ex11_3;

//==============================================