//Coulson & Richardson Chemical Engineering, Volume:01, 6th edition
//Chapter:12, Momentum, Heat & Mass transfer
//Exercise:12.1, Page No.: 714
//Title: Friction factor for a smooth pipe
//================================================
class Ex12_1

//================================================
//Variable section
Real Re "Reynolds Number";
Real phi "Roughness factor";
Real us(unit = "m/s") "Superficial velocity";
Real u_1(unit = "m/s") "velocity";
Real ux_1(unit = "m/s") "velocity at 50mm distance from wall";
Real ux_2(unit = "m/s") "velocity at 5mm distance from wall";
Real del_b(unit = "m") "Thickness of laminar sub-layer in m";
Real del_b1(unit = "mm") "Thickness of laminar sub-layer in mm";
Real ratio_1 "ratio_1 = y1/r";
Real ratio_2 "ratio_2 = y2/r";
Real r(unit = "m") "Radius of smooth circular duct";

//================================================
//Parameter section
parameter Real id(unit = "m") = 250e-3 "Internal diameter of smooth circular duct";
parameter Real u(unit = "m/s") = 15 "Average velocity";
parameter Real rho(unit = "kg/m3") = 1.1 "Density of air";
parameter Real mu(unit = "Ns/m2") = 20e-6 "Viscosity of air";
parameter Real y1(unit = "m") = 50e-3 "Position from wall";
parameter Real y2(unit = "m") = 5e-3 "Position from wall";

//===============================================
//Library section
extends Modelica.ComplexMath;
extends Modelica.Math;

//===============================================
//Equation section
equation
Re = ((id*rho*u)/(mu));
//From figure 3.7, Page No.: 66
phi = 0.0018; 
r = id/2;
us = u/0.817;
u_1 = u*(sqrt(phi));
ratio_1 = y1/r;
ux_1 = (us+(2.5*u_1*(log(ratio_1))));
ratio_2 = y2/r;
ux_2 = (us+(2.5*u_1*(log(ratio_2))));
del_b = (5*id/(Re*(sqrt(phi))));
del_b1 = del_b*1000;
//1000 is multiplied to convert 'm' to 'mm'

end Ex12_1;
//================================================