//Coulson & Richardson Chemical Engineering, Volume:01, 6th edition
//Chapter:13, Humidification and water cooling
//Exercise:13.1, Page No.: 740
//Title: Humidification terms
model Ex13_1
//================================================
//Variable section
Real Pw(unit = "N/m2") "partial pressure of benzene at 297K";
Real m_b(unit = "kg") "mass of benzene";
Real m_n(unit = "kg") "mass of nitrogen";
Real H(unit = "kg/kg") "Humidity";
Real Ho(unit = "kg/kg") "Humidity at 283K";
Real P(unit = "N/m2") "Pressure in N/m2";
Real P_1(unit = "kN/m2") "Pressure in kN/m2";

//=================================================
//Parameter section
parameter Real Pwo(unit = "N/m2") = 12.2e3 "partial pressure of benzene in saturated gas";
parameter Real RH = 60 "Relative humidity";
parameter Real Mw(unit = "kg/kmol") = 78 "Molecular weight of benzene";
parameter Real MA(unit = "kg/kmol") = 28 "Molecular weight of nitrogen";
parameter Real P1(unit = "N/m2") = 101.3e3 "Pressure";
parameter Real R(unit = "J/kmol.K") = 8314 "Universal gas constant";
parameter Real T(unit = "K") = 297 "Temperature";
parameter Real P2(unit = "N/m2") = 6e3 "Pressure at 283K";
parameter Real n = 80 "percent required to recover";

//=================================================
//Equation section
equation
Pw = Pwo*(RH/100);
m_b = (Pw*Mw)/(R*T);
m_n = (P1 - Pw)*MA/(R*T);
H = m_b/m_n;
//In order to recover 80% of benzene, Humidity should be reduced to 20%
Ho = H*(1-(n/100));
Ho = (P2/(P-P2))*(Mw/MA);
P_1 = P/1000;
//1000 is divided to convert pressure from N/m2 to kN/m2

end Ex13_1;
//==================================================