//Coulson & Richardson's Chemical Engineering, Volume-01, 6th Edition
// Chapter-02: Flow of fluids- Energy and Momentum Relationships
// Exercise: 2.4, Page No.:43
// Title: Momentum changes in a fluid

//=================================================================

class Ex2_4

//=================================================================
// Variable section


Real A(unit = "m2") "Area of cylindrical pipe";
Real p(unit = "N") "Momentum per second of liquid in Y-direction";
Real F(unit = "N") "Resultant force in direction of arm of bracket";

//=================================================================
// parameter section


parameter Real v(unit = "m/s")=5 "velocity of water";
parameter Real d(unit = "m")=50e-3 "diameter of pipe";
// 0.001 is multiplied to convert "mm" to "m"
parameter Real a(unit = "deg.")= 90 "pipe bend angle";
parameter Real rho(unit = "kg/m3")=1000 "density of water";

//================================================================
//Library section

extends Modelica.Constants;
extends Modelica.Math;

//================================================================
// Equation section

equation
A=(pi*(d^2))/4;
p=(A*rho*(v^2));
F= (p*cos(a/2)+(p*sin(a/2)));
end Ex2_4;

//=================================================================