////Coulson & Richardson's Chemical Engineering, Volume-01, 6th Edition
// Chapter-02: Flow of fluids- Energy and Momentum Relationships
// Exercise: 2_6, Page No.:54
//Title: Forced vortex

//======================================================
class Ex2_6

//======================================================
//variable section

Real A(unit = "rad/s") "angular speed";
Real P(unit = "N/m2") "Pressure at wals of basket";

//======================================================
// parameter section


parameter Real ri(unit ="m")= 0.15 "inner radius";
parameter Real di(unit="m") = 0.5 "internal diameter";
parameter Real rpm(unit="rad/s")=50 "number of rotations";
parameter Real rho(unit="kg/m3")=1000"density of water";

//=======================================================
extends Modelica.Constants;

//=======================================================
//Equation section

equation
A=(2*pi*rpm);
P=(((rho*(A^2))/2)*(((di/2)^2)-(ri^2)));
end Ex2_6;

//=======================================================