//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chapter-3, Flow of liquids in pipes and open channels
//Exercise:3.11, Page No.:128
//Title: Bingham plastic fluids
//==========================================
class Ex3_11

//==========================================
//Variable section
Real k1(unit = "N*(s^0.33)/m2") "Consistency coefficient for polymer solution";
Real k2(unit = "Ns/m2") "Consistency coefficient for Newtonian fluid";
Real u2(unit = "m/s") "Velocity of polymer solution";
Real u1(unit = "m/s") "Velocity of original Newtonian fluid";
Real r "r = u2/u1";

//=========================================
//Parameter section
parameter Real dux_dy(unit = "1/s") = 1000; 
parameter Real mu_a(unit = "Ns/m2") = 0.1 "Viscosity of Newtonian liquid";
parameter Real n1 = 0.33 "Flow index for polymer solution";
parameter Real n2 = 1 "Flow index for Newtonian fluid";
parameter Real delP(unit = "N/m2") = 1e5 "Pressure drop";
parameter Real L(unit = "m") = 20 "Length of pipe";
parameter Real d(unit = "m") = 25e-3 "diameter of pipe";
 
//==========================================
//Equation section
equation
mu_a = (k1*(dux_dy^(n1-1)));
mu_a = (k2*(dux_dy^(n2-1)));
u2 = (((delP/(4*k1*L))^(1/n1))*(n1/(2*((3*n1)+1)))*(d^((n1+1)/n1)));
u1 = (((delP/(4*k2*L))^(1/n2))*(n2/(2*((3*n2)+1)))*(d^((n2+1)/n2)));
r = u2/u1;

end Ex3_11;
//=========================================