//Coulson & Richardson's Chemical Engineering, volume-1, 6th edition
//Chapter-3, Flow of liquids in pipes and open channels
//Example:3.2, Page No.: 70
//Title: Pressure drop for newtonian liquids through a pipe 
//=====================================================
model Ex3_2

//=====================================================
//Variable section

Real phi(unit = "-") "roughness factor";
Real A(unit = "-");
Real u(unit = "m/s") "maximum allowable water velocity";
Real Re(unit = "-") = 7.9*(10^4) "from chart in page no.: 69, for e/d and phi*(Re^2)values Re =(7.9*(10^4))";

//=====================================================
//Parameter section
parameter Real d(unit = "m") = 50*0.001 "diameter of pipe";
parameter Real l(unit = "m") = 100 "length of pipe";
parameter Real e(unit = "m") = 0.013*0.001 "Roughness of pipe";
parameter Real delP(unit = "Pa") = 50*1000 "Pressure drop";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real mu(unit = "Ns/m2") = 0.001 "viscosity of water";

//=====================================================
//Equation section
equation
A= e/d;
phi*(Re^2)=(delP*(d^3)*rho)/(4*l*(mu^2));

Re = (rho*u*d)/mu;
end Ex3_2;
//=====================================================