// Coulsons & Richardson's Chemical Engineering, Volume-01, 6th edition
// Chapter-03, Flow of liquids in pipes and open channels
//Exercse: 3.3, Page No.:71
//Title: Effect of roughness of pipe surfaces
//=====================================================
class Ex3_3
//=====================================================
//Variable section

Real t(unit = "s") "Time taken for the water level in tank to drop from 3 to 0.3m in seconds";
Real t_1(unit = "min") "Time taken in minutes";
Real r "Relative roughness";
parameter Real phi = 0.002 "phi = (R/rho*(u^2)) Roughness factor";
Real D(unit = "m");


//=====================================================
//Parameter section
parameter Real mu(unit = "N/m2")= 1e-3 "viscosity of water";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real d1(unit = "m") = 225e-3 "diameter of pipe";
parameter Real d2(unit = "m") = 5 "diameter of tank";
parameter Real l(unit = "m") = 100 "length of pipe";
parameter Real e(unit = "m") = 5e-4 "Roughness of new pipe";
parameter Real P1(unit = "N/m2") = 101.3e3 "Pressure in tank";
parameter Real P2(unit = "N/m2") = 101.3e3 "Pressure at pipe outlet";
parameter Real D1(unit = "m") = 3 "Level of water in tank";
parameter Real D2(unit = "m") = 0.3 "Dropped level of water in tank";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";

//====================================================
//Library section
extends Modelica.ComplexMath;
extends Modelica.Constants;

//====================================================
//Equation section
annotation (Experiment(startTime = 0.3, stopTime = 3));
equation
der(t) = 19.63/((pi*(0.225^2)*4.43*sqrt(D)/4)/(sqrt(1+(3552*phi))));
D = time;
r = e/d1;
//From figure 3.7, Page No.: 66 For Re and e/d values phi will be equal to
//phi = 0.002;
t_1 = t/60;

end Ex3_3;
//====================================================

//In simulation setup window from simulation pallet start time and stop time are set to particular value 
//After setting values code is simulated 
//In plotting window D vs t is plotted
//t value is obtained from graph

//====================================================