//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chapter-3, Flow of liquids in pipes and open channels
//Exercise:3.9, Page No.:103 
//Title: Flow in open channels

//===========================================
class Ex3_9
//===========================================
//Variable section
Real d2(unit = "m") "depth of fluid in the channel after jump";
Real u2(unit = "m/s") "velocity of fluid after jump";
Real d2_1(unit = "mm") "depth of fluid in the channel after jump in mm";

//===========================================
//Parameter section
parameter Real u1(unit = "m/s") = 1.5 "velocity of fluid before jump";
parameter Real d1(unit = "m") = 75*0.001 "depth of tank";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";

//===========================================
//Equation section
equation
d2 = 0.5*(-d1+((d1^2+((8*(u1^2)*d1)/g))^0.5));
d2_1 = (d2*1000);
u2 = (u1*d1)/d2;

end Ex3_9;
//===========================================