//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:4, Flow of compressible fluids
//Exercise:4.3, Page No.:168
//Title: Isothermal flow of an ideal gas in a horizontal pipe
//===========================================
model Ex4_3
//===========================================
//Variable section
Real P1_v1;
Real v(unit = "m3/kg") "Specific volume";
Real G(unit = "kg/s") "Mass flowrate of methane";
Real A(unit = "m2") "Area of pipe";
Real G_A(unit = "kg/m2s");
Real Re "Reynolds number";
Real P1(start = 400000, unit = "N/m2") "Pressure developed";
Real r1 "r1 = P1/P2";
Real x;

//===========================================
//Parameter section
parameter Real T(unit = "K") = 288 "Temperature at which methane is discharged";
parameter Real P(unit = "N/m2") = 101.3e3 "Pressure at T";
parameter Real T1(unit = "K") = 297 "Temperature at the exit of compressor";
parameter Real d(unit = "m") = 0.6 "diameter of pipe";
parameter Real l(unit = "m") = 3e3 "length of pipe";
parameter Real r = 0.0001 "r = e/d Relative roughness";
parameter Real mu(unit = "Ns/m2") = 0.01e-3 "Viscosity of methane at 293K";
parameter Real R(unit = "J/moleK") = 8314 "Universal gas constant";
parameter Real M(unit = "kg/kmole") = 16 "Molecular weight of methane";
parameter Real Q(unit = "m3/s") = 50 "Volumetric flowrate of methane";
parameter Real P2(unit = "N/m2") = 170e3 "Pressure at discharge of methane";
parameter Real phi = 0.0015 "From figure: 3.7, Page No.: 66, for Re and e/d value phi = 0.0015 'Roughness factor'";

//===========================================
//Library section
extends Modelica.Math;
extends Modelica.Constants;

//===========================================
//Equation section
equation
P1_v1 = (R*T)/M;
v = ((P1_v1/P)*(T/T1));
G = Q/v;
A = (pi*(d^2))/4;
G_A = G/A;
Re = G_A*d/mu;
(((G_A)^2)*(log(P1/P2)))+(((4*phi*l)/d)*((G_A)^2)) + (((P2^2)-(P1^2))/(2*P1_v1)) = 0;
r1 = P1/P2;
x = (8*phi*l)/d;

//From figure: 4.9, Page No.: 165, for x and r1 value of P1/Pw = 8.1

end Ex4_3;
//============================================