//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.17, Page No.:454
//Title: Radiation from a black body
//===========================================
class Ex9_17
//===========================================
//Variable section
Real F_23 "View factor";
Real A12_A2 "Ratio of area";
//A_12 = A(1+2)
Real A1_A2 "Ratio of area of ring";

//===========================================
//Parameter section
parameter Real ri_u(unit = "m") = 0.2 "Inner radius of upper ring";
parameter Real ro_u(unit = "m") = 0.3 "Outer radius of upper ring ";
parameter Real ri_l(unit = "m") = 0.3 "Inner radius of lower ring";
parameter Real ro_l(unit = "m") = 0.4 "Outer radius of lower ring";
parameter Real F12_34 = 0.4 "View factor";
parameter Real F12_4 = 0.22 "View factor";
parameter Real F1_34 = 0.55 "View factor";
parameter Real F14 = 0.3 "View factor";

//===========================================
//Equation section
equation
A12_A2=(ro_l^2)/((ro_l^2)-(ri_l^2));
A1_A2=((ro_u^2)/((ro_l^2)-(ri_l^2)));
F_23=((A12_A2)*(F12_34-F12_4))+((A1_A2)*(F1_34-F14));

end Ex9_17;
//===========================================