////Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.2, Page No.:390
//Title: Individual and overall coefficients of heat transfer
//===========================================
model Ex9_2
//===========================================
//Variable section
Real Q(unit = "W/m2") "Heat loss per square meter of surface"; 

//===========================================
//Parameter section
parameter Real k(unit = "W/mK") = 0.7 "Thermal conductivity of brick";
parameter Real A(unit = "m2") = 1 "Area";
parameter Real T1(unit = "K") = 400 "Temperature inside the surface";
parameter Real T2(unit = "K") = 300 "Temperature outside the surface";
parameter Real x(unit = "m") = 0.5 "Thickness of brick";

//===========================================
//Equation section
equation
Q = (k*A*(T1-T2))/x;

end Ex9_2;
//===========================================