//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.24, Page No.:498
//Title: Heat transfer in reaction vessels
//===========================================
class Ex9_24
//===========================================
//Variable section
Real rho_u(unit = "kg/m2s");
Real hi(unit = "W/m2K") "Inside film coefficient for water";
Real ho(unit = "W/m2K") "External film coefficient for water";
Real Uo(unit = "W/m2K") "Overall coefficient of heat transfer";
Real dw(unit = "m") "Mean diameter";

//===========================================
//Parameter section
parameter Real G(unit = "kg/s") = 0.5 "Mass flowrate";
parameter Real d(unit = "m") = 22e-3 "Inner diameter";
parameter Real dc(unit = "m") = 0.8 "diameter of helix";
parameter Real k(unit = "W/mK") = 0.59 "Thermal conductivity of water";
parameter Real mu_w(unit = "Ns/m2") = 1.08e-3 "Viscosity of water";
parameter Real Cp(unit = "J/kgK") = 4180 "Specific heat of water";
parameter Real mu_s(unit = "Ns/m2") = 8.6e-3 "Vscosity of sulphuric acid";
parameter Real k1(unit = "W/mK") = 0.4 "Thermal conductivity of sulphuric acid";
parameter Real mu(unit = "Ns/m2") = 6.5e-3 "Viscosity";
parameter Real Cp_s(unit = "J/kgK") = 1.88e3 "Specific heat of sulphuric acid";
parameter Real rho_s(unit = "kg/m3") = 1666 "Density of sulphuric acid";
parameter Real do(unit = "m") = 25e-3 "Outer diameter";
parameter Real xw = 0.0015;
parameter Real kw(unit = "W/mK") = 15.9 "Thermal conductivity";
parameter Real Ro(unit = "m2K/W") = 0.0004 "Scale resistance";
parameter Real Ri(unit = "m2K/W") = 0.0002 "Scale resistance";
parameter Real dv(unit = "m") = 1 "diameter of vessel";
parameter Real N(unit = "Hz") = 2.5 "Number of rotations";
parameter Real L(unit = "m") = 0.3 "diameter of agitator";

//=========================================
//Library section
extends Modelica.Constants;

//=========================================
//Equation section
equation
rho_u = (G/((pi*(d^2))/4));
dw = (d+do)/2;
hi = ((k/d)*(1+(3.5*(d/dc)))*0.023*(((rho_u*d)/mu_w)^0.8)*(((Cp*mu_w)/k)^0.4));
((ho*dv)/k1)*((mu_s/mu)^0.14) = 0.87*(((Cp_s*mu)/k1)^0.33)*((((L^2)*N*rho_s)/mu)^0.62);
(1/Uo) = ((1/ho)+((xw*do)/(dw*kw))+(do/(hi*d))+Ro+((Ri*do)/d));

end Ex9_24;
//=========================================