//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.25, Page No.:501
//Title: Jacketed vessels
//=========================================
class Ex9_25
//=========================================
//Variable section
Real T(start= 0 , unit = "K") "Temperature";
Real t(unit = "s") "time taken in seconds";
Real t_1(unit = "hr") "time taken in hours";
Real T1(start = 0 , unit = "K") "Change in temperature";
Real t1(unit = "s") "time taken to reheat the liquid in seconds";
Real t1_1(unit = "hr") "time taken to reheat the liquid in hours";

//=========================================
//Parameter section
parameter Real Cp(unit = "J/kgK") = 4e3 "Specific heat of liquid";
parameter Real m(unit = "kg") = 1000 "Mass";
parameter Real U1(unit = "W/m2K") = 600 "Overall heat transfer coefficient of liquid";
parameter Real A1(unit = "m2") = 0.5 "Area of coil";
parameter Real U2(unit = "W/m2K") =  10 "Overall heat transfer coefficient of surroundings";
parameter Real A2(unit = "m2") = 6 "Area of vessel";
parameter Real dT_dt = 0 "At equilibrium temperature";
parameter Real t2(unit = "s") = 7200 "Time taken to turn off steam supply";
parameter Real T_1(unit = "K") = 353 "Intial temperature of liquid";
parameter Real T_2(unit = "K") = 293 "Final temperature of liquid";
parameter Real T_3(unit = "K") = 393 "Temperature at which vessel is heated";

//=========================================
//Library section
extends Modelica.Math;


//=========================================
//Equation section
equation

m*Cp*dT_dt = (((U1*A1)*(T_3-T))-((A2*U2)*(T-T_2)));
//After integration
t = ((m*Cp)/((U1*A1)+(U2*A2)))*(log((T-T_2)/(T-T_1)));
t_1 = t/3600;
//3600 is divided to convert units from seconds to hours
//After integration
log((T_2-T_1)/(T_2-T1)) = t2/((m*Cp)/(U2*A2));
//After integration
t1 = ((m*Cp)/((U1*A1)+(U2*A2)))*log((T-T1)/(T-T_1));
t1_1 = t1/3600;
//3600 is divided to convert units from seconds to hours

end Ex9_25;
//=========================================