//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.27, Page No.:521
//Title: Shell and tube heat exchangers
//===========================================
model Ex9_27
//===========================================
//Variable section
Real T(unit = "K") "Mean temperature";
Real hi(unit = "W/m2K") "Inside heat transfer coefficient in W/m2K";
Real hi_1(unit = "kW/m2K") "Inside heat transfer coefficient in kW/m2K"; 
Real ho(unit = "W/m2K") "Shell- side heat transfer coefficient in W/m2K";
Real ho_1(unit = "kW/m2K") "Shell- side heat transfer coefficient in kW/m2K";
Real U(unit = "kW/m2K") "Overall heat transfer coefficient"; 
Real A(unit = "m2") "Heat transfer area";
//===========================================
//Parameter section
parameter Real Q(unit = "kW") = 1672 "Heat load";
parameter Real F_teta_m(unit = "K") = 40.6;
parameter Real T1(unit = "K") = 360 "Temperature of hot water entering heat exchanger";
parameter Real T2(unit = "K") = 340 "Temperature of hot water leaving heat exchanger";
//Assuming tube diameter
parameter Real d(unit = "m") = 0.0019 "diameter of tube";
parameter Real u(unit = "m/s") = 1 "Velocity";
//From Table: 9.18, Page No.:520
parameter Real h_i(unit = "W/m2K") = 1700 "Film coefficents for heat transfer for water";
parameter Real h_o(unit = "W/m2K") = 11000 "Film coefficents for heat transfer for water";
//From Table: 9.16, Page No.: 518 values of  Ri and Ro are
parameter Real Ri(unit = "m2K/kW") = 0.26 "Thermal resistance for water";
parameter Real Ro(unit = "m2K/kW") = 0.26 "Thermal resistance for water";
//For mild steel xw_kw value from Table: 9.15, Page No.: 518
parameter Real xw_kw(unit = "m2K/kW") = 0.025;

//===========================================
//Equation section
equation
T = (T1+T2)/2;
hi = 4280*((0.00488*T)-1)*((u^0.8)/(d^0.2));
hi_1 = hi/1000;
//1000 is divided to convert units from W/m2K to kW/m2K
ho = (h_i+h_o)/2;
ho_1 = ho/1000;
//1000 is divided to convert units from W/m2K to kW/m2K
(1/U) = ((1/ho_1)+(xw_kw)+(Ri+Ro)+(1/hi_1));
A = Q/((F_teta_m)*U);

end Ex9_27;
//===========================================