//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.34, Page No.:560
//Title: Thermal insulation
//===========================================
class Ex9_34
//===========================================
//Variable section
Real Q_l(unit = "W/m") "Heat loss";
Real V(unit = "m3") "Volume of lagging per unit pipe length";
Real v(unit = "euro/ms") "Value of heat lost";
Real CC(unit = "euro/m") "Capital cost of lagging";
Real D(unit = "euro/Ms") "Depreciation";
Real IC(unit = "euro/Ms") "Interest charges";
Real TCC(unit = "euro/Ms") "Total capital charges";
Real delta(unit = "mm") "Economic thickness";
Real hr_k ;
Real do( start= 0.4 , unit = "m")  "Outer diameter";

//===========================================
//Parameter section
parameter Real Ti(unit = "K") = 420 "Temperature of carrying steam";
parameter Real Ta(unit = "K") = 285 "Ambient temperature";
parameter Real k(unit = "W/mK") = 0.1 "Thermal conductivity";
parameter Real di(unit = "m") = 0.1 "Inner diameter";
parameter Real ho(unit = "W/m2K") = 10 "Heat transfer coefficient";
parameter Real value(unit = "/MJ") = 7.5e-4 "Value of heat energy";
parameter Real cost(unit = "/m3") = 10 "Cost per unit volume of material";
parameter Real p = 0.1 "Interest rate";
parameter Real n = 5 "Number of years";
parameter Real t(unit = "s") = 31.5e6 "Time taken for 1 year";


//=============================================
//Library section 
extends Modelica.Constants;
extends Modelica.Math;

//=============================================
//Equation section
equation
Q_l = ((2*pi*k*(Ti-Ta))/((log(do/di))+(1/(h*pi*do))));
v = value*Q_l*e-6;
//e-6 is multiplied to convert /MJ to /J
V = (pi*((di^2)-(do^2)))/4;
CC = cost*V;
D = CC/(n*t);
IC = (p*CC)/t;
TCC = 3*IC;
//C = TCC+v
//After integration
1/(((log(do/di))+(2*pi*k*(1/ho*pi*do)))^2) = 2.35*((do^3)/(do-(2*pi*k*(1/ho*pi))));
delta = ((do-di)*1000)/2;
hr_k = (ho*((di*1000)/2))/k;



end Ex9_34;
//=============================================