//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.6, Page No.:404
//Title: Heating and cooling of solid particles
//==============================================
model Ex9_6
//==============================================
//Variable section
Real V_Ae_sphere(unit = "m") "Ratio of volume to area of sphere";
Real V_Ae_cube(unit = "m") "Ratio of volume to area of cube";
Real Bi "Biot number";
Real tou(unit = "s") "Time taken";
Real teta(unit = "K") "Temperature at time t in 'K'";
Real teta_1(unit = "C") "Temperature at time t in 'C'";
//=============================================
//Parameter section
parameter Real rho(unit = "kg/m3") = 8950 "density of copper";
parameter Real Cp(unit = "kJ/kgK") = 0.38e3 "Specific heat of copper";
parameter Real kp(unit = "W/mK") = 385 "Thermal conductivity";
parameter Real d(unit = "m") = 25e-3 "diameter of sphere";
parameter Real l(unit = "m") = 25e-3 "length of side";
parameter Real h(unit = "W/m2K") = 75 "Heat transfer coefficient";
parameter Real T1(unit = "K") = 368 "Temperature at which both copper sphere and cube are heated in furnance";
parameter Real T2(unit = "K") = 923 "Temperature at which both copper sphere and cube are annealed in air"; 
parameter Real t(unit = "minutes") = 5 "Time taken";
//=============================================
//Library section
extends Modelica.Constants;
extends Modelica.Math;

//=============================================
//Equation section
equation
V_Ae_sphere = ((pi*(d^3))/6)/(pi*(d^2));
V_Ae_cube = ((l^3)/(6*(l^2)));
Bi = (h*V_Ae_sphere)/kp;
//As Bi is less than 0.1
tou = (rho*Cp*V_Ae_sphere)/h;
((teta-T1)/(T2-T1)) = exp((-(t*60))/tou);
//60 is multiplied to convert time into seconds from minutes
teta_1 = teta-273.15;
// Temperature is converted to deg. C

end Ex9_6;
//===============================================