//Coulson & Richardson's Chemical engineering, Volume-01, 6th edition
//Chapter-10, Mass Transfer 
//Exercise-10.1, Page No.: 581
//Title : Mass transfer through a secondary second component
//===============================================
model Ex10_1

//===============================================
//Variable section
Real NA(unit = "kmol/m2s") "Rate of diffusion";
Real PA_1(unit = "N/m2") "partial pressure";
Real PB_1(unit = "N/m2") "partial pressure";
Real PB_2(unit = "N/m2") "partial pressure"; 
Real PB_M(unit = "N/m2") "mean partial pressure";
Real r;

//===============================================
//Parameter section
parameter Real D(unit = "m2/s") = 1.8e-5 "diffusivity of ammonia";
parameter Real R(unit = "J/kmolK") = 8314 "Universal gas constant";
parameter Real T(unit = "K") = 295 "Temperature";
parameter Real P(unit = "N/m2") = 101300 "Atmospheric temperatue";
parameter Real x(unit = "m") = 1e-3 "Thickness of stagnant air";
parameter Real PA_2(unit = "N/m2") = 0;
parameter Real y = 0.5 "percentage by volume of ammonia at boundary of stagnant layer";

//================================================
//Library section
extends Modelica.Math;

//================================================
//Equation section
equation
PA_1 =  y*P;
PB_1 = (P-PA_1);
PB_2 = (P-PA_2);
PB_M = (P-PA_1)/(log(P/PA_1));
r = P/PB_M;
NA = ((D/(R*T*x))*r*(PA_1-PA_2));


//=================================================

end Ex10_1;
//=================================================