//Coulson & Richardson's Chemical engineering, Volume-01, 6th edition
//Chapter-10, Mass Transfer 
//Exercise-10.3, Page No.: 585
//Title : Diffusivity of gases and vapours 
//===============================================
class Ex10_3
//===============================================
//Variable section
Real CA_1(unit = "kmol/m3") "Concentration of ammonia in the gas";
Real CB_M(unit = "kmol/m3") "logarithmic mean of CB_1 and CB_2";
Real NA(unit = "kmol/m2.s") "Molar flux";

//===============================================
//Parameter section
parameter Real v(unit = "m3") = 22.4 "Molecular volume";
parameter Real T1(unit = "K") = 273 "Temperature at STP conditions";
parameter Real T2(unit = "K") = 295 "Temperature of ammonia";
parameter Real CT(unit = "N/m2") = 101.3e3 "Atmospheric pressure";
parameter Real P1(unit = "N/m2") = 101.3e3 "Pressure at 295K";
parameter Real del_y(unit = "m") = 1e-3 "Thickness of film";
parameter Real D(unit = "m2/s") = 2.36e-5 "Diffusivity of ammonia";
parameter Real P2(unit = "N/m2") = 7e3 "partial pressure of ammonia";
parameter Real CA_2(unit = "kmol/m3") = 0 "Concentration";


//================================================
//Library section
extends Modelica.Constants;
extends Modelica.Math;

//================================================
//Equation section
equation
CA_1 = ((1/v)*(T1/T2)*(P1/CT)*(P2/P1));
CB_M = ((P1-(P1-P2))/(log(P1/(P1-P2))));

NA = ((D/del_y)*(CT/CB_M)*(CA_1-CA_2));

//==================================================
end Ex10_3;