//Coulson & Richardson's Chemical engineering, Volume-01, 6th edition
//Chapter-10, Mass Transfer 
//Exercise-10.5, Page No.: 608
//Title : The penetration theory 
//===============================================
class Ex10_5

//===============================================
//Variable section
Real C_b(unit = "kmol/m3") "Bulk concentration";
Real mi(unit = "kmole/m2s") "intial mass transfer rate";
Real del_C(unit = "kmol/m3") "driving force";
Real K(unit = "m/s") "Effective mass transfer coefficient";
Real Eq_r(unit = "s/m") "equivalent resistance";
Real l_r(unit = "s/m") "liquid phase resistance";
Real K_l(unit = "m/s") "liquid phase coefficient";
Real t(unit = "s") "time";

//================================================
//Parameter section
parameter Real T1(unit = "K") = 273 "Temperature at STP conditions";
parameter Real T2(unit = "K") = 293 "Temperature ";
parameter Real D(unit = "m2/s") = 1.5e-9 "Diffusivity in the liquid phase";
parameter Real v(unit = "m3") = 22.4 "volume at STP conditions";
parameter Real r(unit = "m3/m2s") = 50 "Rate of transfer of gas";
parameter Real P(unit = "N/m2") = 101.3 "Pressure";
parameter Real S(unit = "kmol/m3") = 0.04 "Gas solubility";

//================================================
//Library section
extends Modelica.Constants;
extends Modelica.ComplexMath;

//================================================
//Equation section
equation
C_b = (1/v)*(T1/T2);
mi = C_b*r;
del_C = S;
K = mi/del_C;
Eq_r = 1/K;
l_r = 9*Eq_r;
K_l = (sqrt(D/(pi*t)));
K_l = 1/l_r;

end Ex10_5;

//===============================================