//Coulson & Richardson Chemical Engineering, Volume:01, 6th edition
//Chapter:11, The Boundary layer
//Exercise:11.1, Page No.: 680
//Title: The laminar sub-layer
//==============================================
model Ex11_1

//==============================================
//Variable section
Real A(unit = "m2") "area of surface";
Real Fd(unit = "N") "Total drag force"; 
Real mean "mean value of (R/(rho*(us^2)))";
Real Rex "Reynolds number for 1cP viscosity";

//==============================================
//Parameter section
parameter Real us(unit = "m/s") = 1 "velocity of water";
parameter Real w(unit = "m") = 0.6 "width of plane surface";
parameter Real l(unit = "m") = 1 "length of plane surface";
parameter Real Rex_c = 1e5"Reynolds number";
parameter Real mu(unit = "Ns/m2") = 1e-3 "viscosity of water";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";

//===============================================
//Equation section
equation
A = w*l;
Rex = (rho*us*l)/mu;
mean = (0.037*(Rex^(-0.2)))+(((0.064*(Rex_c^0.5))-(0.0037*(Rex_c^0.8)))*(Rex^(-1)));
//Equation 11.41, Page No.:680

Fd = mean*rho*(us^2)*A;

//===============================================

end Ex11_1;
//===============================================