//Coulson & Richardson Chemical Engineering, Volume:01, 6th edition
//Chapter:11, The Boundary layer
//Exercise:11.2, Page No.: 680
//Title: The laminar sub-layer
//==============================================
model Ex11_2

//==============================================
//Variable section
Real Rex "Reynolds number";
Real r "r = del/x" ;
Real del(unit = "m") "thickness of film in m";
Real del1(unit = "mm") "thickness of film in mm";
Real del_1(unit = "mm") "displacement thickness of film in mm";

//==============================================
//Parameter section
parameter Real d(unit = "m") = 150e-3 "distance of boundary layer";
parameter Real mu(unit = "Ns/m2") = 0.05 "viscosity of oil";
parameter Real rho(unit = "kg/m3") = 1000 "density of oil";
parameter Real u(unit = "m/s") = 0.3 "velocity";

//==============================================
//Equation section
equation
Rex = (d*rho*u)/mu;
r = 4.64/(Rex^0.5);
//From equation 11.17, Page No.: 673
del = r*d;
del1 = del*1000;
//1000 is multiplied to convert m to mm
del_1 = 0.375*del1;
//From equation 11.20, Page No.: 674

//===============================================

end Ex11_2;
//===============================================