//Coulson & Richardson Chemical Engineering, Volume:01, 6th edition
//Chapter:12, Momentum, Heat & Mass transfer
//Exercise:12.2, Page No.: 722
//Title: Reynolds Analogy
//===============================================
class Ex12_2
//===============================================
//Variable section
Real Re "Reynolds Number";
Real hD(unit = "m/s") "Heat transfer coefficient";

//===============================================
//Parameter section
parameter Real d(unit = "m") = 20e-3 "Diameter of tube";
parameter Real u(unit = "m/s") = 0.5 "Velocity of water";
parameter Real Sc = 2330 "Schmidt Number";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real mu(unit = "Ns/m2") = 1e-3 "Viscosity of water";

//===============================================
//Equation section
equation
Re = ((rho*u*d)/(mu));
hD = u*(0.032*(Re^(-1/4)))/(1+(2*(Re^(-1/8))*(Sc-1)));

end Ex12_2;
//===============================================