//Coulson & Richardson Chemical Engineering, Volume:01, 6th edition
//Chapter:13, Humidification and water cooling
//Exercise:13.3, Page No.: 743
//Title: Wet- bulb temperature
//================================================
class Ex13_3

//================================================
//Variable section
Real Hw(unit = "kg/kg") "Humidity of air at wet- bulb temperature";
Real H(unit = "kg/kg") "Humidity";
Real Pw(unit = "kN/m2") "saturated pressure";
Real RH(unit = "%") "Percentage Relative Humidity";


//================================================
//Parameter section
parameter Real Mw(unit = "kg/kmol") = 18 "Molecular weight of water";
parameter Real MA(unit = "kg/kmol") = 29 "Molecular weight of air";
parameter Real Pwo_1(unit = "kN/m2") = 3.6 "vapour pressure at 300K";
parameter Real Pwo_2(unit = "kN/m2") = 6.33 "vapour pressure at 310K";
parameter Real P(unit = "kN/m2") = 105 "Total pressure";
parameter Real lambda(unit = "kJ/kg") = 2440 "latent heat of vapourisation";
parameter Real T1(unit = "K") = 300 "Temperature in K";
parameter Real T2(unit = "K") = 310 "Temperature in K";
parameter Real x(unit = "kJ/kg.K") = 1 "x = h/(hD*rho_a)";
parameter Real Hwo(unit = "kg/kg") = 0.078 "Humidity of the saturated gas";
//=================================================
//Equation section
equation
Hw = (Pwo_1/(P- Pwo_1))*(Mw/MA);
(Hw-H) = ((x/lambda)*(T2-T1));
Hwo = (Pw*Mw/(MA*(P-Pw)));
RH = (100*Pw)/Pwo_2;


end Ex13_3;

//=================================================