//Coulson & Richardson's Chemical Engineering, Volume-01, 6th edition
//Chapter-13, Humidificaton and water cooling
//Exercise-13.5, Page No.: 753
//Title : Mixng of two streams of humid gas
//===========================================
class Ex13_5
//===========================================
//Variable section
Real H(unit = "kg/kg") "Humidity";
Real H_0(unit = "kJ/kg") "Enthalpy per mass";
Real teta(unit = "K") "Temperature";


//==========================================
//Parameter section
parameter Real G1(unit = "kg/s") = 1 "Flow rate of air at 350K";
parameter Real G2(unit = "kg/s") = 5 "Flowrate of air at 300K";
parameter Real PH1 = 10 "Percentage humidity at 350K";
parameter Real PH2 = 30 "Percentage humidity at 300K";
//From figure 13.4, Page No.: 747
parameter Real H1(unit = "kg/kg") = 0.043 "Humidity at 350K and 10 percent humidity";
parameter Real H2(unit = "kg/kg") = 0.0065 "Humidity at 300K and 30 percent humidity";
//From figure: 13.5, Page No.: 748
parameter Real H_1(unit = "kJ/kg") = 192 "Enthalpy per mass at 350K";
parameter Real H_2(unit = "kJ/kg") = 42 "Enthalpy per mass at 300K"; 

//==========================================
//Equation section
equation
((G1*H1)+(G2*H2)) = (G1+G2)*H;
(G1*(H_0-H_1)) = ((H_2-H_0)*G2);
//From figure: 13.5
//For H_0 = 0.0125 kg/kg and H = 67 kJ/kg
teta = 309;

end Ex13_5;
//==========================================