// Coulson & Richardson's Chemical Engineering
// chapter-2, Flow of fluids- Energy and momentum relationships
// Exercise: 2_5, Page N0.: 48
// Title: Pressure-volume relationships

//====================================

class Ex2_5
//====================================
//variable section

Real u2(start = 0, unit="m/s") "velocity of jet";

//=====================================
// parameter section


parameter Real P1(unit="N/m2")=250e3 "Pressure";
parameter Real P2(unit="N/m2")=0;
parameter Real u1(unit="m/s")=0; 
parameter Real z1(unit="m")=0 "Horizontal pipe";
parameter Real z2(unit="m")=0 "Horizontal pipe";
parameter Real rho(unit="kg/m3")=1000 "density of water";
parameter Real g(unit="m/s2")=9.81 "acceleration due to gravity";


//======================================
//Equation section

equation
(u2^2-u1^2)/2 = (g*(z1-z2))+((P1-P2)/rho);

end Ex2_5;

//=======================================