//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chapter-3, Flow of liquids in pipes and open channels
//Exercise:3.10, Page No.:127
//Title: Bingham plastic fluids
//==========================================
class Ex3_10

//==========================================
//Variable section
Real up(unit = "m/s") "Centre- line velocity";
Real X;
Real mod_Ry1(unit = "N/m2") "Shear stress at 10 (1/s)";
Real mod_Ry2(unit = "N/m2") "Shear stress at 50 (1/s)";
Real mu_p(unit = "Ns/m2") "Viscosity";
Real Ry(unit = "N/m2") "Intercept";

//==========================================
//Parameter section
parameter Real delP(unit = "N/m2") = 626000 "Pressure drop";
parameter Real l(unit = "m") = 200 "Length of pipe";
parameter Real ucL(unit = "m/s") = 1 "Velocity";
parameter Real r(unit = "m") = 0.02 "Radius of pipe";
parameter Real k(unit = "10N*(s^n)/m2") = 10 "Consistency coefficient";
parameter Real n = 0.2;
parameter Real dux_dy1(unit = "1/s") = 10;
parameter Real dux_dy2(unit = "1/s") = 50;

//==========================================
//Equation section
equation
//Using Power Law
mod_Ry1 = k*(dux_dy1^n);
mod_Ry2 = k*(dux_dy2^n);
//Using the Bingham-plastic model
mod_Ry1 = Ry+(mu_p*(dux_dy1));
mod_Ry2 = Ry+(mu_p*(dux_dy2));
X = (l*2*Ry/(r*delP));
up = ((delP*(r^2))/(8*mu_p*l))*(2-(4*X)+(2*(X^2)));

end Ex3_10;
//===========================================