//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chapter-3, Flow of liquids in pipes and open channels
//Exercise:3.5, Page No.:86
//Title:Velocity distribuitions and volumetric flowrates for turbulent flow
//==========================================
model Ex3_5
//==========================================
//Variable section
//Real Q(unit = "m3/s") "Volumetric flowrate";
//Real Qc(unit = "m3/s") "Volumetric flowrate at centre core";
Real r(unit = "m") "Radius of pipe";
Real a;
Real y1;

//==========================================
//Parameter section
parameter Real d(unit = "m") = 100 "diameter of pipe";
parameter Real y(unit = "m") = 1;

//==========================================
//Library section
extends Modelica.Constants;

//==========================================
//Equation section
equation
r = d/2;
//Q = (2*pi*ucL*(r^2)*(((7/8)*((y/r)^(8/7)))-((7/15)*((y/r)^(15/7))))
//Q = (2*pi*(r^2)*(((7/8)*((y/r)^(8/7)))-((7/15)*((y/r)^(15/7)))));
//Qc = (2*pi*ucL*(r^2)*(((7/8)*((a)^(8/7)))-((7/15)*((a)^(15/7))))
//Qc = (2*pi*(r^2)*(((7/8)*((a)^(8/7)))-((7/15)*((a)^(15/7)))));
//Q = Qc;
((105*(a^(8/7)))-(56*(a^(15/7)))) = 24.5;
a = y1/r;

end Ex3_5;
//==========================================