//Coulson & Richardson's Chemical Engineering, Volume-01, 6th Edition
//Chapter:03, 
//Exercise:3-4,
//Title:
//===================================================
class Ex3_6
//===================================================
//Variable section
Real hf(unit = "m of water")"loss in head";
Real u1(unit = "m/s") "velocity in pipe 1";
Real u2(unit = "m/s") "velocity in pipe 2";
Real A1(unit = "m2") "Area of pipe 1";
Real A2(unit = "m2") "Area of pipe 2";
Real hf_1(unit = "mm of water") "loss in head";
//===================================================
//Parameter section
parameter Real v(unit = "m3/hr") = 7.2 "volumetric flowrate";
parameter Real d1(unit = "m") = 50*0.001 "diameter of pipe 1, 0.001 is multiplied to convert mm to m";
parameter Real d2(unit = "m") = 40*0.001 "diameter of pipe 2, , 0.001 is multiplied to convert mm to m";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";
//===================================================
//Library section
extends Modelica.Constants;
//===================================================
//Equation section
equation
A1 = (pi*(d1^2))/4;
A2 = (pi*(d2^2))/4;
u1 = (v/3600)/A1 "3600 is divided to convert hr to sec";
u2 = (v/3600)/A2 "3600 is divided to convert hr to sec";
hf = ((u1-u2)^2)/(2*g);
hf_1 = hf*1000 "1000 is multiplied to convert m to mm";

end Ex3_6;
//====================================================