//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:4, Flow of compressible fluids
//Exercise:4.2, Page No.:157
//Title: Isothermal flow of an ideal gas in a horizontal pipe
//===========================================
class Ex4_2
//===========================================
//Variable section
Real G_A_1(unit = "kg/m2s") "mass flowrate per area";
Real G_A_2(unit = "kg/m2s") "mass flowrate per area for new values";
Real r2 "r2 = P1/P2";
Real Re "Reynolds Number";
Real x;

//===========================================
//Parameter section
parameter Real P1(unit = "N/m2") = 0.4e3 "Intial pressure ";
parameter Real P2(unit = "N/m2") = 0.13e3 "Final Pressure";
parameter Real l(unit = "m") = 30 "Length of  pipe";
parameter Real d(unit = "m") = 150e-3 "Diameter of pipe";
parameter Real e_d = 0.003 "Relative roughness";
parameter Real R(unit = "J/kmol.K") = 8314 "Universal gas constant";
parameter Real T(unit = "K") = 295 "Temperature";
parameter Real M(unit = "kg/kmol") = 28.9 "Molecular mass of gases";
parameter Real phi = 0.004 "Roughness factor ";
parameter Real mu(unit = "Ns/m2") = 1.8e-5 "Viscosity of air at 295K";
//From figure 3.7, Page No.: 66 phi1 value is
parameter Real phi1 = 0.005 "Roughness factor phi1 = (R/(rho*u^2))";
//From figure 4.9 for value of x, P1/Pw = 3.5
parameter Real r1 = 3.5 "r1 = P1/Pw";

//===========================================
//Library section
extends Modelica.ComplexMath;
extends Modelica.Math;
extends Modelica.Constants;

//===========================================
//Equation section
equation
G_A_1 = sqrt(((((P1^2)-(P2^2))*M)/(2*R*T))/((log(P1/P2))+((4*phi*l)/d)));
Re = G_A_1/mu;


G_A_2 = sqrt(((((P1^2)-(P2^2))*M)/(2*R*T))/((log(P1/P2))+((4*phi1*l)/d)));
x = (8*phi1)/d;

r2 = P1/P2;
end Ex4_2;
//==========================================