//Coulson & Richardson's Chemical Engineering, volume-1, 6th edition
//Chapter-6, Flow and pressure measurement
//Example:6.1, Page No.: 256
//Title: The venturi meter

//==============================================
class Ex6_3

//==============================================
//Variable section

Real CD "discharge coefficient";
Real A1(unit = "m2") "Area of pipe";
Real A2(unit = "m2") "Area of throat";


//==============================================
//Parameter section
parameter Real G(unit = "kg/s") = 2.91 "mass flowrate";
parameter Real d_t(unit = "m") = 50*0.001 "diameter of throat";
parameter Real id(unit = "m") = 150*0.001 "diameter of pipe";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real hv(unit = "m of water") = 121*0.001 "pressure drop over the converging section";

//==============================================
//Library section
extends Modelica.Constants;
extends Modelica.ComplexMath;

//==============================================
//Equation section
equation
A1 = (pi*(id^2)/4);
A2 = (pi*(d_t^2)/4);
G = CD*rho*A1*A2*sqrt(2*g*hv)/(sqrt(A1^2-A2^2)); 
//CD = (G*((A1^2-A2^2)^0.5))/(rho*A1*A2*((2*g*hv)^0.5))

//===============================================
end Ex6_3;

//===============================================