//Coulson & Richardson's Chemical Engineering, volume-1, 6th edition
//Chapter-6, Flow and pressure measurement
//Example:6.5, Page No.: 262
//Title: The notch or weir

//=====================================================
class Ex6_5
//=====================================================
//Variable section
Real Q(unit = "m3/s") "volumetric flow rate";

//=====================================================
//Parameter section
parameter Real D(unit = "m") = 100e-3 "length of weir";
parameter Real L(unit = "m") = 0.5 "length of weir";
parameter Real n = 0 "because notch is the full width of the channel";
parameter Real CD = 1.84 "discharge coefficient";

//======================================================
//Equation section
equation
Q = (CD*(L-(0.1*n*D))*(D^1.5));

//======================================================

end Ex6_5;
//======================================================