//Coluson & Richardson Chemical Engineering, Volume:01, 6th edition
//Chapter:7.3, Liquid mixing
//Exercise:7.3, Page No.:286
//Title: Power consumption in stirred vessels
//===============================================
class Ex7_3

//===============================================
//Variable section
Real k;
Real D1(unit = "m") "impeller diameter";
Real ut1(unit = "m/s") "tip velocity of pilot scale unit";
Real D2(unit = "m") "diameter of full-scale unit";
Real D3(unit = "m") "diameter";
Real N2(unit = "Hz") "rotor speed for full-scale unit";
Real P2(unit = "kW") "Power consumption in full-scale unit";
Real V1(unit = "m3") "volume of pilot scale unit";
Real V2(unit = "m3") "volume of full-scale unit";
Real x "power input per unit volume";
Real P(unit = "kW") "Power requirement";
Real Re "Reynolds number";
Real N_2(unit = "Hz") "rotor speed";
Real Re2 "Reynolds number for full scale unit";

//===============================================
//Parameter section
parameter Real DT(unit = "m") = 0.6 "diameter of tank";
parameter Real N1(unit = "Hz") = 4 "rotor speed";
parameter Real P1(unit = "kW") = 0.15 "Power consumption in pilot plant unit";
parameter Real Re1 = 160000 "Reynolds number for pilot plant unit";


//===============================================
//Library section
extends Modelica.Constants;

//===============================================
//Equation section
equation
//for pilot plant D1 = DT/3
D1 = DT/3;
D2 = 6*D1;
k = P1/((N1^3)*(D1^5));
//constant impeller speed
ut1 = pi*N1*D1;
//ut1 = ut2
N2 = ut1/(pi*D2);
P2 = k*(N2^3)*(D2^5);
//for thermal similarity, that is same temperature in both systems, i.e., viscosity and density are same for both plants 
Re2 = Re1*(N2*(D2^2))/(N1*(D1^2));
//constant power input per unit volume
//assuming depth of liquid is equal to tank diameter
V1 = (pi/4)*(DT^2)*DT;
//Power input per unit volume
x = P1/V1;
D3 = 6*DT;
V2 = (pi/4)*(D3^2)*D3;
P = x*V2;
N_2 = ((P/((D2^5)*k))^(1/3));
Re = (Re1*((D2^2)*N_2)/((D1^2)*N1));

//===============================================

end Ex7_3;

//================================================