//Coulson & Richardson's Chemical Engineering, Volume-01, 6th edition
//Chapter-08, Pumping of fluids
//Exercise: 8.1, Page No,: 321
//Title: The metering pump
//======================================================

model Ex8_1
//======================================================
//Variable section

Real ap(unit = "m/s2") "acceleration of piston";
Real max_a(unit = "m/s2") "maximum acceleration";
Real max_a1(unit = "m/s2") "maximum acceleration of the liquid in suction pipe";
Real F(unit = "N") "accelerating force";
Real delP(unit = "N/m2") "pressure drop in suction line due to acceleration in N/m2";
Real delP1(unit = "m water") "pressure drop in suction line due to acceleration in m water";
Real N(start = 0, unit = "Hz") "maximum permissible speed of the pump";

//=======================================================
//Parameter section

parameter Real D(unit = "m") = 110e-3 "cylinder diameter";
parameter Real Ds(unit = "m") = 230e-3 "stroke diameter";
parameter Real Dsl(unit = "m") = 50e-3 "suction line diameter";
parameter Real l(unit = "m") = 6 "suction line length";
parameter Real lw(unit = "m") = 3 "water level in suction tank";
parameter Real H(unit = "m of water") = 1.2 "pressure head";
parameter Real Pa(unit = "m of water") = 10.36 "atmospheric pressure head";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";
parameter Real t(unit = "s") = 0 "Maximum velocity at time = 0";

//========================================================
//Library section

extends Modelica.Constants;
extends Modelica.Math;

//========================================================
//Equation section

equation
ap = (Dsl*Ds*((2*pi*N)^2)*(cos(2*pi*N*t)));
//At maximum velocity
//t=0;
max_a = (Dsl*Ds*((2*pi*N)^2));
max_a1 = (max_a*((D/Dsl)^2));
F = (max_a1*(pi/4)*(Dsl^2)*l*rho);
delP = max_a1*l*rho;
delP1 = delP/(rho*g);
H = (Pa-lw-delP1);

end Ex8_1;

//=========================================================