//Coluson & Richardson's Chemical Engineering,Volume-01, 6th edition
//Chapter-8, Pumping of fluids
//Exercise:8.2, Page No.:343
//Title: Pumping of non- Newtonian fluids

//=====================================================

class Ex8_2
//=====================================================
//Variable section

Real u(unit = "m/s") "velocity of liquid";
Real Re "Reynolds number";
Real phi "friction factor";
Real Area(unit = "m2") "Area of pipe";
Real hf_l(unit = "m/ m of pipe") "head loss per unit length";
Real hf(unit = "m") "head loss";
Real l(unit = "m") "length of pipe";
Real ho(unit = "m") "height between liquid level in the reboiler and pump";

//=====================================================
//Parameter section
parameter Real Q(unit = "m3/s") = 0.0004 "volumetric flowrate of liquid";
parameter Real rho(unit = "kg/m3")= 800 "density of liquid";
parameter Real mu(unit = "Ns/m2") = 0.5e-3 "viscosity of liquid";
parameter Real d(unit = "m") = 25e-3 "diameter of pipe";
parameter Real z(unit = "m") = 2 "Net Postive Suction Head";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";

 //====================================================
 //Library section
 extends Modelica.Constants;
 
 //====================================================
 //Equation section
 equation
 Area = (pi*(d^2))/4;
 u = Q/Area;
 Re = (rho*d*u)/mu;
 phi = 0.0028 "from figure: 3.7, Page No.:66";
 hf_l = 4*phi*(u^2)/(d*g);
 l = 10 "for minimum value of ho";
 hf = hf_l*l;
 ho = z+hf;
 
end Ex8_2;
//====================================================