//Coulson & Richardson's Chemical Engineering, volume - 01, 6th edition
//Chapter -8, Pumping of fluids
//Exercise: 8.4, Page No.:357
//Title: Compressor efficiencies
//=================================================
model Ex8_4

//=================================================
//Variable section
Real C "Overall compression ratio";
Real v(unit = "m3/kg") "specific volume";
Real w(unit = "J/kg") "work of compression in J/kg";
Real w1(unit = "kJ/kg") "work of compression in kJ/kg";
Real E(unit = "kJ/kg") "Energy supplied to the compressor";
Real W(unit = "J/kg") "work done in isothermal compression";
Real W1(unit = "kJ/kg") "work done during isotherma compression in kJ/kg";
Real W2(unit = "kJ/kg") "work done during isentropic compression";
Real W3(unit = "kJ/kg") "work done during isentropic compression in kJ/kg";
Real ni(unit = "%") "isothermal efficiency";
Real ni_1(unit = "%") "isentropic efficiency";
Real Vs_1(unit = "m3/kg") "swept volume in 1st cylinder";
Real Vs_2(unit = "m3/kg") "swept volume in 2nd cylinder";
Real Vs_r "Swept volume ratio";

//====================================================
//Parameter section
parameter Real P1(unit = "kN/m2") = 101.3 "pressure before compression";
parameter Real P2(unit = "kN/m2") = 2065 "pressure after compression";
parameter Real T1(unit = "K") = 273 "Temperature at STP conditions";
parameter Real T2(unit = "K") = 290 "Temperature of gas before entering compressor";
parameter Real n(unit = "%") = 0.85 "mechanical efficency";
parameter Real C1 = 0.04 "clearance in 1st cylinder";
parameter Real C2 = 0.05 "clearance in 2nd cylinder";
parameter Real gamma1 = 1.25 "from equation P(V^2.5) = constant";
parameter Real gamma2 = 1.4 "for isentropic compression";
parameter Real V1(unit = "m3") = 22.414 "volume at STP conditions";
parameter Real V2(unit = "m3") = 28.8 "volume of gas entering 1st compressor";

//====================================================
//Library section
extends Modelica.Math;

//====================================================
//Equation section
equation
C = P2/P1;
v = (V1/V2)*(T2/T1);
w = P1*1000*v*2*(gamma1/(gamma1-1))*((C^((gamma1-1)/2.5))-1);
//1000 is mulitiplied to convert P1 units from kN/m2 to N/m2
w1 = w*0.001;
//0.001 is multiplied to convert J/kg to kJ/kg
E = w1/n;
W = P1*1000*v*log(C);
W1 = W*0.001;
ni = 100*(W1/E);
W2 = P1*1000*v*(gamma2/(gamma2-1))*((C^((gamma2-1)/gamma2))-1);
W3 = W2*0.001;
ni_1 = 100*(W3/E);
Vs_1 = v/(1+C1-(C1*(C^(1/(2*gamma1)))));
Vs_2 = v*((1/C)^0.5)/(1+C2-C2*(C^(1/(2*gamma1))));
Vs_r = Vs_1/Vs_2;

end Ex8_4;
//======================================================