//Coluson & Richardson's Chemical Engineering,Volume-01, 6th edition
//Chapter-8, Pumping of fluids
//Exercise:8.5, Page No.:360
//Title: The air-lift pump
//========================================
model Ex8_5

//========================================
//Variable section
Real G(unit = "kg/s") "mass flowrate";
Real W(unit = "W") "Work per unit time";
Real Wa(unit = "W") "actual work of expansion";
Real Va(unit = "m3/kg") "specific volume of air";
Real Ga(unit = "kg/s") "mass flowrate of air"; 
Real Q(unit = "m3/s") "volumetric flowrate";
Real P(unit = "W") "Power for compression in W";
Real P_1(unit = "kW") "Power for compression in kW";

//===========================================
//Parameter section
parameter Real Q1(unit = "m3/s") = 7.5e-4 "volumetric flowrate after using air-lift pump";
parameter Real rho(unit = "kg/m3") = 1200 "density";
parameter Real z(unit = "m") = 20 "height";
parameter Real P1(unit = "kN/m2") = 450 "pressure of air at height 20m";
parameter Real Pa(unit = "kN/m2") = 101.3 "atmospheric pressure";
parameter Real v(unit = "m3") = 22.414 "volume at STP conditions";
parameter Real n(unit = "%") = 0.3 "efficiency of pump";
parameter Real gamma = 1.4 "for isentropic compression";
parameter Real g(unit = "m/s2") = 9.81 "accleration due to gravity";
parameter Real Mw(unit = "kg/kmol") = 28.9 "Molecular weight of air";

//===========================================
//Library section
extends Modelica.Math;

//===========================================
//Equation section
equation
G = Q1*rho;
W = G*g*z;
Wa = W/n;
Va = v/Mw;
Ga = Wa/(Pa*1000*Va*(log(P1/Pa)));
Q = Ga*Va;
P = Pa*1000*Q*(gamma/(gamma-1))*(((P1/Pa)^((gamma-1)/gamma))-1);
// 1000 is multiplied to convert kN/m2 to N/m2
P_1 = P/1000;
//1000 is divided to convert power units from W to kW

end Ex8_5;
//============================================