//Coluson & Richardson's Chemical Engineering,Volume-01, 6th edition
//Chapter-8, Pumping of fluids
//Exercise:8.6, Page No.:360
//Title: The air-lift pump
//=============================================
model Ex8_6

//=============================================
//Variable section
Real G(unit = "kg/s") "mass flowrate";
Real W(unit = "W") "Work per unit time";
Real E(unit = "J") "Energy to compress 0.1m3/s of air";
Real Va(unit = "m3/kg") "specific volume of air at 273K";
Real V(unit = "m3/kg") "specific volume of air at 101.3 kN/m2";
Real Ga(unit = "kg/s") "mass flowrate of air"; 
Real n(unit = "%") "efficiency of pump";
Real P(unit = "J") "Power for compression in J";
Real Pa(unit = "kN/m2") "pressure of air";
Real mean_P(unit = "kN/m2") "mean pressure";
Real Area(unit = "m2") "Area of pipe";
Real z2(unit = "m") "water level in well";
Real mean_u(unit = "m/s") "mean velocity";
Real mean_Q(unit = "m3/s") "mean volumetric flowrate";
Real Total_Q(unit = "m3/s") "Total volumetric flowrate";

//===========================================
//Parameter section
parameter Real Q1(unit = "m3/s") = 0.01 "volumetric flowrate after using air-lift pump";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real z(unit = "m") = 100 "depth of well";
parameter Real z1(unit = "m") = 40 "water level below the surface";
parameter Real d(unit = "m") = 100e-3 "diameter of pipe";
parameter Real V1(unit = "m3/s") = 0.1 "volumetric flowrate of air";
parameter Real P2(unit = "kN/m2") = 800 "pressure";
parameter Real P1(unit = "kN/m2") = 101.3 "atmospheric pressure";
parameter Real T(unit = "K") = 273 "Temperature at STP conditions";
parameter Real gamma = 1.4 "for isentropic compression";
parameter Real g(unit = "m/s2") = 9.81 "accleration due to gravity";
parameter Real Mw(unit = "kg/kmol") = 28.9 "Molecular weight of air";
parameter Real R(unit = "J/kmol.K") = 8314 "Universal gas constant";
//===========================================
//Library section
extends Modelica.Constants;
extends Modelica.Math;

//===========================================
//Equation section
equation
G = Q1*rho;
W = G*g*z1;
E = P1*1000*V1*(gamma/(gamma-1))*(((P2/P1)^((gamma-1)/gamma))-1);
//1000 is multiplied to convert pressure into kN/m2 from N/m2
Ga = V1/V;
P = E;
n = (W*100)/P;
z2 = z-z1;
Pa = (z2*g*rho)/1000;
//1000 is divided to convert pressure into kN/m2 from N/m2
mean_P = (P1+Pa)/2;
Va = R*T/(1000*Mw*mean_P);
V = R*T/(Mw*P1*1000);
//1000 is multiplied to convert pressure into kN/m2 from N/m2
mean_Q = Ga*Va;
Total_Q = Q1+mean_Q;
Area = (pi*(d^2))/4;
mean_u = Total_Q/Area;

end Ex8_6;
//==============================================