//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.11, Page No.:437
//Title: Convection to spherical particles
//==========================================
model Ex9_11
//==========================================
//Variable section
Real Y;
Real GrPr "Grasshoff number * Prandtl number";
Real h(unit = "W/m2K") "Heat transfer coefficient";
Real mean_T(unit = "K") "Mean temperature";

//==========================================
//Parameter section
 parameter Real l(unit = "m") = 0.15 "diameter of horizontal pipe";
 parameter Real T1(unit = "K") = 294 "Surface temperature";
 parameter Real T2(unit = "K") = 400 "Temperature of air";
parameter Real X = 36 "X = ((k^4)*(beta*g*(rho^2)*Cp))/(mu*k)";
parameter Real k(unit = "W/mK") = 0.0310 "Thermal conductivity at mean temperature taken from Appendix A1, Table 6, Page No.: 796";
parameter Real n = 0.25 "From table 9.5, Page No.: 435";
parameter Real C = 1.32 "From table 9.5, Page No.: 435";

//==========================================
//Equation section
equation
mean_T = (T1+T2)/2;
Y = X/(k^4);
GrPr = (Y*(T2-T1)*(l^3));
h = 1.32*((T2-T1)^n)*(l^((3*n)-1));
end Ex9_11; 
//==========================================