//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.12, Page No.:439
//Title: Radiation from a black body
//===========================================
model Ex9_12
//===========================================
//Variable section
Real T(unit = "K") "Temperature of a surface coated with carbon black";
Real T_1(unit = "K") "Temperature of a surface coated with carbon black with 2% error";
Real E_lambda_b1(unit = "W/m3") "Emissive power with 2% error";

//===========================================
//Parameter section
parameter Real C1(unit = "W/m2") = 3.742e-16 "Radiation coefficient";
parameter Real C2(unit = "W/m2") = 1.439e-2 "Radiation coefficient";
parameter Real E_lambda_b(unit = "W/m3") = 1e9 "Emissive power";
parameter Real lambda(unit = "m") = 1e-6 "Wave length";
parameter Real P(unit = "%") = 2 "Percentage error";


//===========================================
extends Modelica.Math;

//===========================================
//Equation section
equation
exp(C2/(lambda*T)) = (C1/(E_lambda_b*(lambda^5)))+1;
E_lambda_b1 = ((100-P)*E_lambda_b)/100;
E_lambda_b1 = C1/((lambda^5)*(exp(C2/(lambda*T_1))-1));

end Ex9_12;
//===========================================