//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.13, Page No.:439
//Title: Radiation from a black body
//===========================================
class Ex9_13
//===========================================
//Variable section
Real Eb(unit = "W/m2") "Total emissive power";
Real Area(unit = "m2") "Area of one element";
Real Power(unit = "W") "Power dissipated by one element";
Real N "Number of elements required";

//==========================================
//Parameter section
parameter Real T(unit = "K") = 1750 "Surface temperature";
parameter Real sigma(unit = "W/m2K4") = 5.67e-8 "Stefan- Boltzmann constant";
parameter Real d(unit = "m") = 10e-3 "diameter of element";
parameter Real l(unit = "m") = 0.5 "Length of element";
parameter Real Q(unit = "W") = 500e3 "Radiated thermal output";

//==========================================
//Library section
extends Modelica.Constants;

//==========================================
//Equation section
equation
Eb = sigma*(T^4);
Area = pi*d*l;
Power = Eb*Area;
N = (Q/Power);
end Ex9_13;
//==========================================