//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.15, Page No.:448
//Title: Radiation from a black body
//===========================================
class Ex9_15
//===========================================
//Variable section
Real A1(unit = "m2") "Area of rectangle";
Real A2(unit = "m2") "Area of sphere";
Real F_21 "View factor";
Real Q_12(unit = "W") "Radiation transfer between two bodies in W";
Real Q_12_1(unit = "kW") "Radiation transfer between two bodies in kW";

//===========================================
//Parameter section
parameter Real sigma(unit = "W/m2K4") = 5.67e-8 "Stefan- Boltzmann constant";
parameter Real l(unit = "m") = 2 "Length of rectangle";
parameter Real b(unit = "m") = 1 "Breadth of rectangle";
parameter Real d(unit = "m") = 1 "diameter of disc";
parameter Real T1(unit = "K") = 1500 "Temperature of rectangle";
parameter Real T2(unit = "K") = 750 "Temperature of disc";
parameter Real F_12 = 0.25 "View factor";

//===========================================
//Library section
extends Modelica.Constants;

//===========================================
//Equation section
equation
A1 = l*b;
A2 = (pi*(d^2))/4;
A1*F_12 = A2*F_21;
Q_12 = sigma*A1*F_12*((T1^4)-(T2^4));
Q_12_1 = Q_12/1000;
//1000 is divided to convert W to kW

end Ex9_15;
//===========================================