//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.16, Page No.:449
//Title: Radiation from a black body
//===========================================
package Ex9_16
  class a
    //=======================================
    //Variable section
    Real F_12 "View factor";
    Real F_21 "View factor";
    Real r "r = Y/X";
    Real r_1 "r_1 = Z/X";
    Real A1(unit = "m2") "Area of Vertical plate";
    Real A2(unit = "m2") "Area of horizontal plate";
    //=======================================
    //Parameter section
    parameter Real X(unit = "m") = 4 "width of horizontal plate";
    parameter Real Y(unit = "m") = 6 "Length of horizontal plate";
    parameter Real Z(unit = "m") = 3 "Height of vertical plate";
    //========================================
    //Equation section
  equation
    r = Y / X;
    r_1 = Z / X;
    F_12 = 0.12;
//From figure: 9.40 (iii), Page No.: 452, for values of r ana r_1 F_12 is extraploted
    A1 = X * Z;
    A2 = Y * X;
    A1 * F_12 = A2 * F_21;
  end a;

  class b
  //==========================================
  //Variable section
  Real F_21 "View factor";
  Real F_22 "View factor";
  
  //==========================================
  //Parameter section
  parameter Real r1(unit = "m") = 1 "diameter of sphere which is placed inside another sphere";
  parameter Real r2(unit = "m") = 2 "diameter of outside sphere";
  parameter Real F_12 = 1 "View factor";
  
  //==========================================
  //Equation section
  equation
  F_21 = ((r1/r2)^2);
  F_22 = 1-((r1/r2)^2);
  
  end b;
end Ex9_16;
//=============================================