//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.26, Page No.:516
//Title: Shell and tube heat exchangers
//===========================================
model Ex9_26
//===========================================
//Variable section
Real X;
Real Y;

Real teta2(unit = "K") "Cooling water outlet temperature";
Real teta_m(unit = "K") "Mean temperature";
Real F_teta_m(unit = "K") ;
Real A(unit = "m2") "Heat transfer area";

//===========================================
//Parameter section
//From exercise 9.1, Page No.: 386
parameter Real Q(unit = "kW") = 1672 "Heat transfer load";
 parameter Real G1(unit = "kg/s") = 25 "Mass flowrate of water used to cool";
parameter Real Cp(unit = "kJ/kg") = 4.18 "Specfic heat of water";
parameter Real teta1(unit = "K") = 300 "Temperature of cold water entering heat exchanger";
parameter Real T1(unit = "K") = 360 "Temperature of hot water entering heat exchanger";
parameter Real T2(unit = "K") = 340 "Temperature of hot water leaving heat exchanger";
parameter Real U(unit = "kW/m2K") = 2 "Overall heat transfer coefficient";
//From figure 9.58, Page No.: 495
parameter Real F = 0.97;


//===========================================
//Equation section
equation
Q = G1 * Cp * (teta2 - teta1);
X = ((teta2-teta1)/(T1-teta1));
Y = ((T1-T2)/(teta2-teta1));

teta_m = ((T1 - teta2) - (T2 - teta1)) / log((T1 - teta2) / (T2 - teta1));

F_teta_m = F*teta_m;
A = Q/(U*F_teta_m); 
end Ex9_26;