//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.28, Page No.:531
//Title: Heat exchanger design
//===========================================
class Ex9_28
//=======================================
//Variable section
Real mean_T(unit = "K") "Mean temperature";
Real Q(unit = "kW") "Heat load";
Real G(unit = "kg/s") "Mass flowrate of cooling water";
Real teta_m(unit = "K") "Logaithmic mean temperature difference";
Real X;
Real Y;
Real F_teta_m;
Real A(unit = "m2") "Area";
Real S(unit = "m2") "Surface area of one tube";
Real N "Number of tubes required";
Real db(start = 0, unit = "mm") "Bundle diameter";
Real ds(unit = "mm") "Shell diameter";
 Real Area(unit = "m2") "Cross-sectional area of one tube";
 Real N_pass "Number of tubes per pass";
 Real A_t(unit = "m2") "Tube side area";
 Real mA(unit = "kg/m2s") "Mass flowrate per unit area";
 Real u(unit = "m/s") "Water velocity";
 Real mean_T1(unit = "K") "Mean temperature";
Real mean_T2(unit = "K") "Mean temperature";
 Real Re "Reynolds number";
Real Pr "Prandtl number";
Real l_di;
Real hi(unit = "W/m2K") "Inside heat transfer coefficient";
Real As(unit = "m2") "Cross-flow area"; 
Real Gs(unit = "kg/s") "Mass velocity in shell";
Real de(unit = "mm") "Equivalent diameter";
Real Re_1 "Reynolds number";
Real Pr_1 "Prandtl number";
Real hs(unit = "W/m2K") "Shell side heat transfer coefficient";
Real r "r = ((mu_1/mu_s)^0.14)";
Real d(unit = "mm") "Shell diameter";
Real pitch(unit = "mm") "Tube pitch";
Real U_1(unit = "W/m2K") "Overall heat transfer coefficient";
Real xw(unit = "m") "Wall thickness";
Real del_Pt(unit = "N/m2") "Tube side pressure drop in N/m2";
Real del_Pt_1(unit = "kN/m2") "Tube side pressure drop kN/m2";
Real u_1(unit = "m/s") "Linear velocity";
Real del_Ps(unit = "N/m2") "Shell side pressure drop in N/m2";
Real del_Ps_1(unit = "kN/m2") "Shell side pressure drop in kN/m2";
Real del_Ps_2(unit = "kN/m2") "Shell side pressure drop in kN/m2";
Real ho(unit = "W/m2K") "Heat transfer coefficient";
Real U_2(unit = "W/m2K") "Overall heat transfer coefficient";

//========================================
//Parameter section
parameter Real T1(unit = "K") = 370 "Temperature of butyl alcohol enterinng";
parameter Real T2(unit = "K") = 315 "Temperature of butyl alcohol leaving heat exchanger";
parameter Real T3(unit = "K") = 300 "Temperature of water enterinng";
parameter Real m(unit = "kg/s") = 30 "Mass flowrate of butyl alcohol";
parameter Real Cp(unit = "kJ/kgK") = 2.9 "Specific heat of butyl alcohol";
parameter Real Cp_w(unit = "kJ/kgK") = 4.18 "Specific heat of water";
//From Table: 9.17, Page No.:519 value of U
parameter Real U(unit = "W/m2K") = 500 "Overall heat transfer coefficient";
//From Figure: 9.75, Page No.:514
parameter Real F = 0.85;
parameter Real do(unit = "m") = 20e-3 "Outer diameter";
parameter Real di(unit = "m") = 16e-3 "Inner diameter";
parameter Real l(unit = "m") = 4.83 "Effective tube length";
//From Table: 9.13, Page No.: 509 value of a for triangular pitch
parameter Real a = 0.249;
//From Figure: 9.71, Page No.: 512 value of dc
parameter Real dc(unit = "mm") = 68 "Diameteric clearance between the shell and tube";
parameter Real n =  2 "Number of pass";
parameter Real rho(unit = "kg/m3") = 995 "Mean density of water";
parameter Real rho_1(unit = "kg/m3") = 780 "density of butyl alcohol";
parameter Real k(unit = "W/mK") = 0.59 "Thermal conductivity of water";
parameter Real k_1(unit = "W/mK") = 0.16 "Thermal conductivity of butyl alcohol";
parameter Real mu(unit = "Ns/m2") = 0.8e-3 "Viscosity of water";
parameter Real mu_1(unit = "Ns/m2") = 0.75e-3 "Viscosity of butyl alcohol";
//From Figure: 9.77, Page No.: 522 value of jh is
parameter Real jh = 3.7e-3;
parameter Real jh_1 = 5e-3;
parameter Real Cp_1(unit = "kJ/kgK") = 3.1 "Specific heat";
parameter Real p(unit = "%") = 20 "percent";
parameter Real mu_s(unit = "Ns/m2") = 1.1 "Viscosity at mean temperature";
parameter Real kw(unit = "W/mK") = 50 "Thermal conductivity of copper-nickel alloys";
parameter Real Ri(unit = "m2K/W") = 0.00015 "Scale resistance of organic";
parameter Real Ro(unit = "m2K/W") = 0.0002 "Scale resistance of water";
//From Figure: 9.78, Page No.: 525, for particular Re value of friction factor (jf) is
parameter Real jf = 4.5e-3;
parameter Real jf_1 = 4.6e-2;

//========================================
//Library section
extends Modelica.Constants;
extends Modelica.Math;

//========================================
//Equation section
equation
mean_T = (T1+T2)/2;
Q = m*Cp*(T1-T2);
G = Q/(Cp_w*(T2-T3));
teta_m = ((T1-T2)-(T2-T3))/(log((T1-T2)/(T2-T3)));
X = ((T1-T2)/(T2-T3));
Y = ((T2-T3)/(T1-T3));
F_teta_m = F*teta_m;
A = ((Q*1000)/(U*F_teta_m));
S = pi*(l*do);
N = A/S;
N = a*((db/(do*1000))^2.207);
ds = db+dc;
Area = (pi*(di^2))/4;
N_pass = N/n;
A_t = N_pass*Area;
mA = G/A_t;
u = mA/rho;
mean_T1 = (T2+T3)/2;
Re = (rho*di*u)/mu;
Pr = (Cp_w*1000*mu)/k;
l_di = l/di;
((hi*di)/k)= (jh*Re*(Pr^0.33));
d = (ds*p)/100;
pitch = 1.25*do;
As = ((pitch-do)/pitch)*(ds*d/(10^6));
Gs = m/As;
de = 1.1*((pitch^2)-(0.917*(do^2)))/do;
Re_1 = (Gs*de)/mu_1;
Pr_1 = (Cp_1*1000*mu_1)/k_1;
mean_T2 = (T2+T3)/2;
(hs*de)/k_1 = jh_1*Re_1*(Pr_1^0.33);
r = ((mu_1/mu_s)^0.14);
xw = (do-di)/2;
(1/U_1) = (1/hs)+Ro+(xw/kw)+(Ri/(do/di))+((1/hi)*(do/di));
del_Pt = n*((4*jf*(4.830/di))+1.25)*(rho*(u^2));
del_Pt_1 = del_Pt/1000;
u_1 = Gs/rho_1;
del_Ps = (4*jf_1)*(ds/(de))*(4.830/d)*(rho_1*(u_1^2));
del_Ps_1 = del_Ps/1000;
del_Ps_2 = del_Ps_1/4;
ho = 1933*((1/2)^0.8);
(1/U_2) = Ro+(xw/kw)+(1/ho)+(Ri/(do/di))+((1/hi)*(do/di));

end Ex9_28;
//========================================