//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.29, Page No.:535
//Title: Shell and tube heat exchangers
//===========================================
class Ex9_29
//===========================================
//Variable section
Real Q(unit = "kW") "Heat load";
Real G_cool(unit = "kg/s") "Flow rate of water";
Real G_Cp_hot(unit = "kW/K");
Real G_Cp_cold(unit = "kW/K");
Real eta "Effectiveness";
//===========================================
//Parameter section
parameter Real T1(unit = "K") = 350 "Temperature of organic liquid to be cooled";
parameter Real T2(unit = "K") = 330 "Temperature of organic liquid after cooling";
parameter Real Cp(unit = "kJ/kgK") = 2 "Specific heat of organic liquid";
parameter Real G(unit = "kg/s") = 1 "Mass flowrate";
parameter Real Cp_w(unit = "kJ/kgK") = 4.18 "Specific heat of water";
parameter Real T3(unit = "K") = 290 "Temperature of water entering heat exchanger";
parameter Real T4(unit = "K") = 320 "Temperature of water leaving heat exchanger";

//===========================================
//Equation section
equation
Q = G*Cp*(T1-T2);
G_cool = Q/(Cp_w*(T4-T3));
G_Cp_hot = G*Cp;
G_Cp_cold = G_cool*Cp_w;
eta = ((G_Cp_hot*(T1-T2))/(G_Cp_cold*(T1-T3)));

end Ex9_29;
//===========================================