////Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.3, Page No.:391
//Title: Thermal resistance in series
//==============================================
class Ex9_3
//==============================================
//Variable section
Real Q(unit = "W/m2") "Heat loss per unit surface area"; 
Real T(unit = "K") "Temperature drop over firebrick";
Real T1(unit = "K") "Temperature at the firebrick- insulating brick interface ";

//=============================================
//Parameter section
parameter Real T_1(unit = "K") = 1200 "Temperature at inside surface";
parameter Real T_2(unit = "K") = 330 "Temperature at outside surface";
parameter Real x1(unit = "m") = 0.2 "Thickness of firebrick";
parameter Real x2(unit = "m") = 0.1 "Thickness of insulating brick";
parameter Real x3(unit = "m") = 0.2 "Thickness of ordinary brick";
parameter Real A(unit = "m2") = 1 "Area of brick";
parameter Real k1(unit = "W/mK") = 1.4 "Thermal conductivity of firebrick";
parameter Real k2(unit = "W/mK") = 0.21 "Thermal conductivity of insulating brick";
parameter Real k3(unit = "W/mK") = 0.7 "Thermal conductivity of ordinary brick";

//=============================================
//Equation section
equation
Q = (T_1-T_2)/((x1/(A*k1))+(x2/(A*k2))+(x3/(A*k3)));
T = ((T_1-T_2)*(x1/(A*k1)))/((x1/(A*k1))+(x2/(A*k2))+(x3/(A*k3)));
T1 = T_1-T;

end Ex9_3;
//=============================================