//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.30, Page No.:538
//Title: Shell and tube heat exchangers
//===========================================
package Ex9_30
  class a
    //=========================================
    //Variable section
    Real G_Cp(unit = "kW/K") "For untreated water";
    Real G_Cp_min(unit = "kW/K") "For purified water";
    Real r "r = G_Cp_1/G_Cp";
    Real eta "Effectiveness";
    Real A(unit = "m2") "Area required";
    //=========================================
    //Parameter section
    parameter Real G(unit = "kg/s") = 8 "Mass flowrate of untreated water";
    parameter Real G_1(unit = "kg/s") = 4 "Mass flowrate of purified water";
    parameter Real Cp(unit = "kJ/kgK") = 4.18 "Specific heat of water";
    parameter Real T11(unit = "K") = 380 "Temperature of untreated water";
    parameter Real T1(unit = "K") = 340 "Temperature of purifed water";
    parameter Real T2(unit = "K") = 320 "Temperature of purified water to be heated";
    //From Figure: 9.85b, Page No.: 539, value of N for r and eta is
    parameter Real N = 0.45 "Number of transfer units";
    parameter Real U(unit = "kW/m2K") = 1.5 "Overall heat transfer coefficient";
    //=========================================
    //Equation section
  equation
    G_Cp = G * Cp;
    G_Cp_min = G_1 * Cp;
    r = G_Cp_min / G_Cp;
    eta = G_1 * Cp * (T1 - T2) / (G_1 * Cp * (T11 - T2));
    A = N * G_Cp_min / U;
  end a;

  class b
  //=========================================
    //Variable section
    Real G_Cp(unit = "kW/K") "For untreated water";
    Real G_Cp_min(unit = "kW/K") "For purified water";
    Real r "r = G_Cp_1/G_Cp";
    Real eta "Effectiveness";
    Real A(unit = "m2") "Area required";
    //=========================================
    //Parameter section
    parameter Real G(unit = "kg/s") = 8 "Mass flowrate of untreated water";
    parameter Real G_1(unit = "kg/s") = 4 "Mass flowrate of purified water";
    parameter Real Cp(unit = "kJ/kgK") = 4.18 "Specific heat of water";
    parameter Real T11(unit = "K") = 370 "Temperature of untreated water";
    parameter Real T1(unit = "K") = 340 "Temperature of purifed water";
    parameter Real T2(unit = "K") = 320 "Temperature of purified water to be heated";
    //From Figure: 9.85b, Page No.: 539, value of N for r and eta is
    parameter Real N = 0.6 "Number of transfer units";
    parameter Real U(unit = "kW/m2K") = 1.5 "Overall heat transfer coefficient";
    //=========================================
    //Equation section
  equation
    G_Cp = G * Cp;
    G_Cp_min = G_1 * Cp;
    r = G_Cp_min / G_Cp;
    eta = G_1 * Cp * (T1 - T2) / (G_1 * Cp * (T11 - T2));
    A = N * G_Cp_min / U;
  end b;

  class c
  //=========================================
    //Variable section
    Real G_Cp(unit = "kW/K") "For untreated water";
    Real G_Cp_min(unit = "kW/K") "For purified water";
    Real r "r = G_Cp_1/G_Cp";
    Real eta "Effectiveness";
    Real A(unit = "m2") "Area required";
    //=========================================
    //Parameter section
    parameter Real G(unit = "kg/s") = 8 "Mass flowrate of untreated water";
    parameter Real G_1(unit = "kg/s") = 4 "Mass flowrate of purified water";
    parameter Real Cp(unit = "kJ/kgK") = 4.18 "Specific heat of water";
    parameter Real T11(unit = "K") = 360 "Temperature of untreated water";
    parameter Real T1(unit = "K") = 340 "Temperature of purifed water";
    parameter Real T2(unit = "K") = 320 "Temperature of purified water to be heated";
    //From Figure: 9.85b, Page No.: 539, value of N for r and eta is
    parameter Real N = 0.9 "Number of transfer units";
    parameter Real U(unit = "kW/m2K") = 1.5 "Overall heat transfer coefficient";
    //=========================================
    //Equation section
  equation
    G_Cp = G * Cp;
    G_Cp_min = G_1 * Cp;
    r = G_Cp_min / G_Cp;
    eta = G_1 * Cp * (T1 - T2) / (G_1 * Cp * (T11 - T2));
    A = N * G_Cp_min / U;
  
  end c;

  class d
  //=========================================
    //Variable section
    Real G_Cp(unit = "kW/K") "For untreated water";
    Real G_Cp_min(unit = "kW/K") "For purified water";
    Real r "r = G_Cp_1/G_Cp";
    Real eta "Effectiveness";
    Real A(unit = "m2") "Area required";
    //=========================================
    //Parameter section
    parameter Real G(unit = "kg/s") = 8 "Mass flowrate of untreated water";
    parameter Real G_1(unit = "kg/s") = 4 "Mass flowrate of purified water";
    parameter Real Cp(unit = "kJ/kgK") = 4.18 "Specific heat of water";
    parameter Real T11(unit = "K") = 350 "Temperature of untreated water";
    parameter Real T1(unit = "K") = 340 "Temperature of purifed water";
    parameter Real T2(unit = "K") = 320 "Temperature of purified water to be heated";
    //From Figure: 9.85b, Page No.: 539, value of N for r and eta is
    parameter Real N = 1.7 "Number of transfer units";
    parameter Real U(unit = "kW/m2K") = 1.5 "Overall heat transfer coefficient";
    //=========================================
    //Equation section
  equation
    G_Cp = G * Cp;
    G_Cp_min = G_1 * Cp;
    r = G_Cp_min / G_Cp;
    eta = G_1 * Cp * (T1 - T2) / (G_1 * Cp * (T11 - T2));
    A = N * G_Cp_min / U;
  
  
  end d;
end Ex9_30;
//=============================================
