////Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.4, Page No.:398
//Title: Unsteady state conduction
//==============================================
class Ex9_4

//==============================================
//Variable section
Real t(unit = "sec") "Time taken in seconds";
Real t_1(unit = "hr") "Time taken in hours";
Real teta;


//==============================================
//Parameter section
parameter Real DH(unit = "cm2/s") = 0.0043 "Thermal diffusivity";
parameter Real T1(unit = "K") = 295 "Intial temperature";
parameter Real T2(unit = "K") = 375 "Final temperature";
parameter Real T3(unit = "K") = 900 "Sudden rise in temperature";
parameter Real l(unit = "m") = 0.45 "thickness";

//=============================================
//Library section
extends Modelica.ComplexMath;

//=============================================
//Equation section
equation
// erfc((l*((2*N)+1))/(2*sqrt(DH))) 
 teta = (T2-T1)/(2*(T3-T1));
 teta*20 = 346*(t^(-0.5));
 t_1 = t/3600;
 
end Ex9_4;
//=============================================