//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.7, Page No.:409
//Title: Heating and cooling of solid particles
//============================================
model Ex9_7

//============================================
//Variable section
Real Bi "Biot number";
Real r "Limiting value";
Real t(unit = "s") "Time taken for heating in seconds";
Real t_1(unit = "min") "Time taken for heating in minutes";

//=============================================
//Parameter section
parameter Real h(unit = "W/m2K") = 100 "Heat transfer coefficient";
parameter Real L(unit = "m") = 5e-3 "Thickness of sheet";
//Temperature will be maximum at centre of plate
parameter Real kp(unit = "W/mK") = 2.5 "Thermal conductivity";
parameter Real teta_1(unit = "K") = 373 "Temperature";
parameter Real teta_c(unit = "K") = 353 "Minimum temperature";
parameter Real teta_o(unit = "K") = 293 "Intial temperature";
parameter Real DH(unit = "m2/s") = 2e-7 "Thermal diffusivity";
parameter Real Fo = 7.7 "Fourier number";
//Fourier number is taken from Figure: 9.17

//=============================================
//Equation section
equation
Bi = (h*L)/kp;
r = ((teta_1 - teta_c)/(teta_1-teta_o));
t = ((L^2)*Fo)/DH;
t_1 = t/60;
//60 is divide to convert seconds to minutes

end Ex9_7;
//=============================================